#include "cron.ih"

// define a bash function _run_ executing its argument(s) by bash's eval
// command, sending its output either to /dev/null or mailing it to the
// configured mailer program
// the _run_ function is then called by sendchild.cc

    // by parentprocess.cc

namespace {

char const devnull[] = 
R"(
    _run_()
    {
        eval $* 2>&1 > /dev/null
    }
)";

char const beginRun[] = 
R"(
    _run_()
    {
        out=`eval $* 2>&1`
        [ "$out" == "" ] || echo "$out" | )";

char const endRun[] = 
R"(
    }
)";

} // namespace

void Cron::defineRun()
{
    std::string const &mailer = d_options.mailer();

    if (mailer.empty())
        *d_toChild << devnull;
    else
        *d_toChild << beginRun << mailer << endRun;

    idmsg() << "defined _run_()" << endl;
}
