#ifndef _CONTIG_SELECT_H_
#define _CONTIG_SELECT_H_

#include "io_utils.h"
#include "cs-object.h"
#include "canvas_box.h"

#define TASK_CS_REDRAW       0
#define TASK_CS_PLOT         1
#define TASK_CS_SAVE         2
#define TASK_CS_LOAD         3

// For FIJ
#define TASK_AUTO_JOIN       4

extern HTablePtr csplot_hash[HASHMODULUS];

typedef struct {
    int buffer_count;
    int do_update;
    char hori[100];
    char vert[100];
    tag_s tag;
    tick_s *tick;
    cursor_s cursor;
    int line_width;
    char *line_colour;

    char frame[100];
    char window[100];
    int spare; /* RE-USE this */
    win **win_list;
    int num_wins;
    WorldPtr *world;
    CanvasPtr *canvas;
    StackPtr *zoom;
} obj_cs;


/* determines the position of a base in terms of the entire database */
int64_t
find_position_in_DB(GapIO *io, 
		    tg_rec c_num, 
		    int64_t position);

void
PlotRepeats(GapIO *io, 
	    mobj_repeat *repeat);

/* draw the contig lines of the contig selector */
int
Draw_CS_Contigs(Tcl_Interp *interp,                                    /* in */
		GapIO *io,                                             /* in */
		char *win_name,                                        /* in */
		char *colour,                                          /* in */
		int width,                                             /* in */
		int tick_wd,                                           /* in */
		int tick_ht,                                           /* in */
		int offset,                                            /* in */
		char *direction);                                      /* in */

void
update_contig_order(Tcl_Interp *interp,
		    GapIO *io,
		    int cs_id,
		    contig_list_t *order_array,
		    int num_contigs,
		    int64_t cx);

void
ReOrder(GapIO *io, 
	tg_rec *order,
	int c_from,
	int c_to); 

void
move_matches(int item_num);

void
plot_cs_tags(Tcl_Interp *interp,                                       /* in */
	     GapIO *io,                                                /* in */
	     char *win_name,                                           /* in */
	     int width,                                                /* in */
	     int offset);                                              /* in */
int
contig_selector_reg(Tcl_Interp *interp, 
		    GapIO *io, 
		    char *frame,
		    char *csh_win,
		    tag_s tag,
		    cursor_s cursor,
		    tick_s *tick);
int
contig_comparator_reg(Tcl_Interp *interp, 
		      GapIO *io, 
		      obj_cs *cs,
		      char *csp_win,
		      char *csv_win);

int tk_clear_cp(ClientData clientData, Tcl_Interp *interp,
		int objc, Tcl_Obj *CONST argv[]);

int tk_matchresult_configure(ClientData clientData, Tcl_Interp *interp,
			     int objc, Tcl_Obj *CONST argv[]);

#endif
