use core;
use core:debug;

Int testArray() {
	Array<Dbg> a;

	for (Int i = 0; i < 22; i++) {
		a << Dbg(i);
	}

	a[1] = Dbg(0);

	Int sum = 0;
	for (Nat i = 0; i < a.count; i++) {
		sum = sum + a[i].get;
	}

	sum;
}

Int testIntArray() {
	Int[] a;

	for (Int i = 0; i < 20; i++)
		a << i;

	for (Int i = 5; i < 15; i++)
		a[i.nat] = 0;

	Int sum;
	for (Nat i = 0; i < a.count; i++)
		sum = sum + a[i];

	sum;
}

Int testInitArray() {
	Int[] a = Int:[1, 3, 3, 7];

	Int sum;
	for (Nat i = 0; i < a.count; i++)
		sum = sum * 10 + a[i];

	sum;

	// Comments with brackets in them causes problems?
	// for foo () {
	// }
	// Hope not!
}

Int testInitAutoArray() {
	var a = [1, 2, 3, 4];

	Int sum;
	for (Nat i = 0; i < a.count; i++)
		sum = sum * 10 + a[i];

	sum;
}

Int testAutoArray() {
	Int[] a = [];
	a.count.int;
}

Int testCastArray() {
	Dbg a(10);
	Dbg b(20);
	Object[] z = [a, b];
	z.count.int;
}

Array<Int> createValArray() {
	Array<Int> a;

	for (Int i = 0; i < 20; i++)
		a << Int(i);

	a;
}

Array<DbgActor> createActorArray() {
	Array<DbgActor> dbg;
	for (Int i = 0; i < 4; i++)
		dbg << DbgActor(i + 1);

	dbg;
}

Int testIterator() {
	Int[] data = [1, 2, 3, 4, 5];
	Int sum = 0;

	for (i in data) {
		sum += i;
	}

	sum;
}

Int testIteratorIndex() {
	Int[] data = [3, 2, 1, 4];
	Int sum = 0;

	for (k, v in data) {
		sum += k.int * v;
	}

	sum;
}

Array<Int> smallIntArray() {
	Array<Int> r;
	for (Int i = 0; i < 5; i++)
		r << (5 - i);
	r;
}

Str sortArray() {
	Array<Int> arr = smallIntArray();
	arr.sort();
	arr.toS;
}

Str sortedArray() {
	Array<Int> arr = smallIntArray();
	arr.sorted.toS + arr.toS;
}

private Bool sortPred(Int a, Int b) {
	a = (a + 2) % 5;
	b = (b + 2) % 5;
	a < b;
}

Str sortArrayP() {
	Array<Int> arr = smallIntArray();
	arr.sort(&sortPred(Int, Int));
	arr.toS;
}

Str sortedArrayP() {
	Array<Int> arr = smallIntArray();
	arr.sorted(&sortPred(Int, Int)).toS + arr.toS;
}
