/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_PROPLISTITEM_H
#define _SVN_PROPLISTITEM_H

// sc
#include "util/String.h"
//#include "svn.h"

// svn
struct svn_client_proplist_item_t;

// sys
#include <map>


namespace svn
{

// svn_client_proplist_item_t
class PropListItem
{
public:
  typedef std::map<sc::String,sc::String> Props;

  PropListItem( svn_client_proplist_item_t* );
  PropListItem( const PropListItem& src );

  const sc::String& getName() const;
  const Props& getProps() const;

private:
  sc::String _name;
  Props      _props;
};


} // namespace

#endif // _SVN_PROPLISTITEM_H
