from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_maybe_copy = _Mock()

_safe_is_tarfile = _Mock()

_should_copy = _Mock()

aliases = _Mock()

basename = _Mock()

cast_unicode_py2 = _Mock()

check_nbextension = _Mock()

flags = _Mock()

get_ipython_dir = _Mock()

install_nbextension = _Mock()

os = _Mock()

pjoin = _Mock()

print_function = _Mock()

shutil = _Mock()

string_types = _Mock()

tarfile = _Mock()

urlparse = _Mock()

urlretrieve = _Mock()

zipfile = _Mock()



class BaseIPythonApplication(_Mock):
  pass
  _in_init_profile_dir = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Enum(_Mock):
  pass
  info_text = 'any value'

class NBExtensionApp(_Mock):
  pass
  _in_init_profile_dir = False
  description = 'Install IPython notebook extensions\n    \n    Usage\n    \n        ipython install-nbextension file [more files, folders, archives or urls]\n    \n    This copies files and/or folders into the IPython nbextensions directory.\n    If a URL is given, it will be downloaded.\n    If an archive is given, it will be extracted into nbextensions.\n    If the requested files are already up to date, no action is taken\n    unless --overwrite is specified.\n    '
  examples = '\n    ipython install-nbextension /path/to/d3.js /path/to/myextension\n    '

class TemporaryDirectory(_Mock):
  pass


