from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


Object = _Mock()

PyTango = _Mock()

_command = _Mock()

_dumps = _Mock()

connect = _Mock()

dumps = _Mock()

functools = _Mock()

get_attributes_config = _Mock()

get_commands_config = _Mock()

get_object_db = _Mock()

get_object_info = _Mock()

get_object_name = _Mock()

get_object_proxy = _Mock()

loads = _Mock()

_FMT = 'pickle'

class CmdArgType(_Mock):
  pass


class Device(_Mock):
  pass


class _Device(_Mock):
  pass


class _DeviceHelper(_Mock):
  pass


