from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


CODECS = _Mock()

CODING_RE = _Mock()

decode = _Mock()

encode = _Mock()

get_coding = _Mock()

getfilesystemencoding = _Mock()

is_binary_string = _Mock()

is_string = _Mock()

is_text_file = _Mock()

is_unicode = _Mock()

locale = _Mock()

os = _Mock()

re = _Mock()

read = _Mock()

readlines = _Mock()

sys = _Mock()

to_fs_from_unicode = _Mock()

to_text_string = _Mock()

to_unicode = _Mock()

to_unicode_from_fs = _Mock()

transcode = _Mock()

write = _Mock()

writelines = _Mock()

BOM_UTF16 = '\xff\xfe'

BOM_UTF32 = '\xff\xfe\x00\x00'

BOM_UTF8 = '\xef\xbb\xbf'

FS_ENCODING = 'UTF-8'

PREFERRED_ENCODING = 'UTF-8'



