package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVpcGatewayEndpoints invokes the vpc.ListVpcGatewayEndpoints API synchronously
func (client *Client) ListVpcGatewayEndpoints(request *ListVpcGatewayEndpointsRequest) (response *ListVpcGatewayEndpointsResponse, err error) {
	response = CreateListVpcGatewayEndpointsResponse()
	err = client.DoAction(request, response)
	return
}

// ListVpcGatewayEndpointsWithChan invokes the vpc.ListVpcGatewayEndpoints API asynchronously
func (client *Client) ListVpcGatewayEndpointsWithChan(request *ListVpcGatewayEndpointsRequest) (<-chan *ListVpcGatewayEndpointsResponse, <-chan error) {
	responseChan := make(chan *ListVpcGatewayEndpointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVpcGatewayEndpoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVpcGatewayEndpointsWithCallback invokes the vpc.ListVpcGatewayEndpoints API asynchronously
func (client *Client) ListVpcGatewayEndpointsWithCallback(request *ListVpcGatewayEndpointsRequest, callback func(response *ListVpcGatewayEndpointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVpcGatewayEndpointsResponse
		var err error
		defer close(result)
		response, err = client.ListVpcGatewayEndpoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVpcGatewayEndpointsRequest is the request struct for api ListVpcGatewayEndpoints
type ListVpcGatewayEndpointsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	EndpointId           string           `position:"Query" name:"EndpointId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	ServiceName          string           `position:"Query" name:"ServiceName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	EndpointName         string           `position:"Query" name:"EndpointName"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
}

// ListVpcGatewayEndpointsResponse is the response struct for api ListVpcGatewayEndpoints
type ListVpcGatewayEndpointsResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	NextToken  string     `json:"NextToken" xml:"NextToken"`
	TotalCount int64      `json:"TotalCount" xml:"TotalCount"`
	MaxResults int64      `json:"MaxResults" xml:"MaxResults"`
	Endpoints  []Endpoint `json:"Endpoints" xml:"Endpoints"`
}

// CreateListVpcGatewayEndpointsRequest creates a request to invoke ListVpcGatewayEndpoints API
func CreateListVpcGatewayEndpointsRequest() (request *ListVpcGatewayEndpointsRequest) {
	request = &ListVpcGatewayEndpointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListVpcGatewayEndpoints", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVpcGatewayEndpointsResponse creates a response to parse from ListVpcGatewayEndpoints response
func CreateListVpcGatewayEndpointsResponse() (response *ListVpcGatewayEndpointsResponse) {
	response = &ListVpcGatewayEndpointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
