/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.util;

import java.awt.Shape;
import java.awt.Stroke;
import org.piccolo2d.util.PPickPath;

abstract class PSemanticStroke
implements Stroke {
    protected static final double THRESHOLD = 1.0E-6;
    private transient float recentScale;
    private transient Stroke recentStroke;
    protected final Stroke stroke;

    protected PSemanticStroke(Stroke stroke) {
        this.stroke = stroke;
        this.recentStroke = stroke;
        this.recentScale = 1.0f;
    }

    public Shape createStrokedShape(Shape s) {
        float currentScale = this.getActiveScale();
        if ((double)Math.abs(currentScale - this.recentScale) > 1.0E-6) {
            this.recentScale = currentScale;
            this.recentStroke = this.newStroke(this.recentScale);
        }
        return this.recentStroke.createStrokedShape(s);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PSemanticStroke other = (PSemanticStroke)obj;
        return !(this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke));
    }

    protected float getActiveScale() {
        if (PPickPath.CURRENT_PICK_PATH != null) {
            return (float)PPickPath.CURRENT_PICK_PATH.getScale();
        }
        return 1.0f;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31;
        if (this.stroke != null) {
            result += this.stroke.hashCode();
        }
        return result;
    }

    protected abstract Stroke newStroke(float var1);

    public String toString() {
        return this.stroke.toString();
    }
}

