// @HEADER
// *****************************************************************************
//        MueLu: A package for multigrid based preconditioning
//
// Copyright 2012 NTESS and the MueLu contributors.
// SPDX-License-Identifier: BSD-3-Clause
// *****************************************************************************
// @HEADER

#ifndef MUELU_REPARTITIONBLOCKDIAGONALFACTORY_DECL_HPP_
#define MUELU_REPARTITIONBLOCKDIAGONALFACTORY_DECL_HPP_

#include <Xpetra_Import_fwd.hpp>

#include "MueLu_SingleLevelFactoryBase.hpp"
#include "MueLu_RepartitionBlockDiagonalFactory_fwd.hpp"

#include "MueLu_Level_fwd.hpp"
#include "MueLu_FactoryBase_fwd.hpp"

namespace MueLu {

/*!
  @class RepartitionBlockDiagonalFactory
  @brief Factory which rebalances a map on current level using the Importer object generated by the RepartitionFactory
*/

template <class Scalar        = DefaultScalar,
          class LocalOrdinal  = DefaultLocalOrdinal,
          class GlobalOrdinal = DefaultGlobalOrdinal,
          class Node          = DefaultNode>
class RepartitionBlockDiagonalFactory : public SingleLevelFactoryBase {
#undef MUELU_REPARTITIONBLOCKDIAGONALFACTORY_SHORT
#include "MueLu_UseShortNames.hpp"

 public:
  //! @name Constructors/Destructors
  //@{

  //! Constructor
  RepartitionBlockDiagonalFactory() {}

  //! Destructor
  virtual ~RepartitionBlockDiagonalFactory() {}
  //@}

  RCP<const ParameterList> GetValidParameterList() const;

  //! @name Input
  //@{
  void DeclareInput(Level &level) const;
  //@}

  //! @name Build methods.
  //@{
  void Build(Level &level) const;

  //@}
};

}  // namespace MueLu

#define MUELU_REPARTITIONBLOCKDIAGONALFACTORY_SHORT

#endif /* MUELU_REPARTITIONBLOCKDIAGONALFACTORY_DECL_HPP_ */
