#Boa:Frame:AddURL
#TunaPie (c)2005-2009 James Stone.
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#
#Written using Boa-Constructor.
#http://boa-constructor.sourceforge.net/
#
#Version 0.0.2  30/01/09

import wx
import wx.lib.buttons
import wx.lib.masked.numctrl
import wx.lib.masked.textctrl
import wx.lib.stattext
import tuner

def create(parent):
    return AddURL(parent)

[wxID_ADDURL, wxID_ADDURLBITRATETEXT, wxID_ADDURLBITRATETEXTCTRL, 
 wxID_ADDURLCANCELBUTTON, wxID_ADDURLGENRETEXT, wxID_ADDURLGENRETEXTCTRL, 
 wxID_ADDURLNAMETEXT, wxID_ADDURLNAMETEXTCTRL, wxID_ADDURLOKBUTTON, 
 wxID_ADDURLTYPECHOICE, wxID_ADDURLTYPETEXT, wxID_ADDURLURLTEXT, 
 wxID_ADDURLURLTEXTCTRL, 
] = [wx.NewId() for _init_ctrls in range(13)]

class AddURL(wx.Dialog):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self, id=wxID_ADDURL, name=u'AddURL', parent=prnt,
              pos=wx.Point(542, 257), size=wx.Size(427, 229),
              style=wx.DEFAULT_DIALOG_STYLE, title=u'Edit Stream Info')
        self.SetClientSize(wx.Size(427, 229))
        self.SetBackgroundColour(wx.Colour(212, 216, 224))
        self.SetBackgroundStyle(wx.BG_STYLE_SYSTEM)
        self.SetThemeEnabled(True)

        self.nametext = wx.lib.stattext.GenStaticText(ID=wxID_ADDURLNAMETEXT,
              label=u'Name', name=u'nametext', parent=self, pos=wx.Point(24,
              24), size=wx.Size(39, 17), style=0)

        self.urltext = wx.lib.stattext.GenStaticText(ID=wxID_ADDURLURLTEXT,
              label=u'URL', name=u'urltext', parent=self, pos=wx.Point(24, 64),
              size=wx.Size(25, 17), style=0)

        self.typetext = wx.lib.stattext.GenStaticText(ID=wxID_ADDURLTYPETEXT,
              label=u'Type', name=u'typetext', parent=self, pos=wx.Point(24,
              104), size=wx.Size(29, 17), style=0)

        self.genretext = wx.lib.stattext.GenStaticText(ID=wxID_ADDURLGENRETEXT,
              label=u'Genre', name=u'genretext', parent=self, pos=wx.Point(24,
              144), size=wx.Size(39, 17), style=0)

        self.bitratetext = wx.lib.stattext.GenStaticText(ID=wxID_ADDURLBITRATETEXT,
              label=u'Bitrate', name=u'bitratetext', parent=self,
              pos=wx.Point(24, 184), size=wx.Size(43, 17), style=0)

        self.typechoice = wx.Choice(choices=['TV', 'Radio'],
              id=wxID_ADDURLTYPECHOICE, name=u'typechoice', parent=self,
              pos=wx.Point(88, 104), size=wx.Size(144, 27), style=0)
        self.typechoice.SetSelection(1)

        self.okbutton = wx.Button(id=wxID_ADDURLOKBUTTON,
              label=u'OK', name=u'okbutton', parent=self, pos=wx.Point(304,
              184), size=wx.Size(86, 24), style=0)
        self.okbutton.SetAutoLayout(True)
        self.okbutton.SetThemeEnabled(True)
        self.okbutton.Bind(wx.EVT_BUTTON, self.OnOkbuttonButton,
              id=wxID_ADDURLOKBUTTON)

        self.cancelbutton = wx.Button(id=wxID_ADDURLCANCELBUTTON,
              label=u'Cancel', name=u'cancelbutton', parent=self,
              pos=wx.Point(192, 184), size=wx.Size(88, 24), style=0)
        self.okbutton.SetAutoLayout(True)
        self.okbutton.SetThemeEnabled(True)
        self.cancelbutton.Bind(wx.EVT_BUTTON, self.OnCancelbuttonButton,
              id=wxID_ADDURLCANCELBUTTON)

        self.nametextctrl = wx.TextCtrl(id=wxID_ADDURLNAMETEXTCTRL,
              name=u'nametextctrl', parent=self, pos=wx.Point(88, 24),
              size=wx.Size(304, 25), style=0, value=u'')

        self.urltextctrl = wx.TextCtrl(id=wxID_ADDURLURLTEXTCTRL,
              name=u'urltextctrl', parent=self, pos=wx.Point(88, 64),
              size=wx.Size(304, 25), style=0, value=u'')

        self.genretextctrl = wx.TextCtrl(id=wxID_ADDURLGENRETEXTCTRL,
              name=u'genretextctrl', parent=self, pos=wx.Point(88, 144),
              size=wx.Size(304, 25), style=0, value=u'')

        self.bitratetextctrl = wx.TextCtrl(id=wxID_ADDURLBITRATETEXTCTRL,
              name=u'bitratetextctrl', parent=self, pos=wx.Point(88, 184),
              size=wx.Size(80, 25), style=0, value=u'')

    def __init__(self, parent):
        self._init_ctrls(parent)
        self.parent=parent
        
    def setfontsize(self, newsize):
        size=int(newsize)
        self.nametext.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.urltext.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.typetext.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genretext.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.bitratetext.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.nametextctrl.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.urltextctrl.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.typechoice.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.genretextctrl.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.bitratetextctrl.SetFont(wx.Font(size, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.okbutton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))
        self.cancelbutton.SetFont(wx.Font(size-1, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Sans'))

    def OnOkbuttonButton(self, event):
        self.parent.favname.append(self.nametextctrl.GetValue())
        self.parent.favurl.append(self.urltextctrl.GetValue())
        self.parent.favmod.append(self.typechoice.GetCurrentSelection())
        self.parent.favplay.append("")
        try: self.parent.favbit.append(str(int(self.bitratetextctrl.GetValue())))
        except ValueError:
            self.parent.favbit.append("0")
        self.parent.favgen.append(self.genretextctrl.GetValue())
        self.parent.favlist.append("0")
        self.parent.favname,self.parent.favlist, self.parent.favgen, self.parent.favbit, self.parent.favurl, \
        self.parent.favplay, self.parent.favmod=self.parent.sort(self.parent.fcol,self.parent.favname,self.parent.favlist,\
        self.parent.favgen, self.parent.favbit, self.parent.favurl, self.parent.favplay, self.parent.reverse, self.parent.favmod)
        self.parent.addtolistctrl(self.parent.FaveListCtrl, self.parent.favname,self.parent.favgen,self.parent.favbit,self.parent.favlist,self.parent.favplay,self.parent.favmod)
        tuner.savefavorites(self.parent.home,self.parent.favname,self.parent.favurl,self.parent.favlist,\
            self.parent.favplay,self.parent.favbit,self.parent.favgen,self.parent.favmod)     
        self.Close()
        
    def OnCancelbuttonButton(self, event):
        self.Close()
