/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//*****************************************************************************
//
// Class:	 UNSWSManClient
// Date created: 9 May 2006
// Description:	 This class is used to subscribe the User Notification Service
//		 for events at the local AMT machine.
//
//*****************************************************************************

#ifndef UNS_WSMAN_CLIENT_H
#define UNS_WSMAN_CLIENT_H

#include "BaseWSManClient.h"
#include "AMT_SOAPEventSubscriber.h"
#include "Credentials.h"
#include <string>

using namespace std;
using namespace CimClassNamespace;

class UNSWSManClient : public BaseWSManClient
{
private:
	// Data members
	Credentials							m_SubscribeCred;// Credentials used to subscribed.
	AMT_SOAPEventSubscriber				m_Subscriber;

public:

	// Contructors and Destructor.
	UNSWSManClient();

	virtual ~UNSWSManClient();

	bool	GenerateCredentials();				// Generate random userid and passwd.

	string  GetUserid()		{ return m_SubscribeCred.username ; }	// Return the subscription userid.
	string  GetPasswd()		{ return m_SubscribeCred.password; }	// Return the subscription passwd.
	bool	IsSubscribed()	{ return m_subscribed;}	// Return true iff client is subscribed to AMT.

	/*Actual soap commands!*/
	unsigned long	SubscribeForGeneralAlert	(int port);	// Subscribe For General Alert to local AMT.
	unsigned long	DeletePreviousSubscriptions	();		// Delete previous UNS subscriptions.
	unsigned long	CancelAlertSubscription		(unsigned int *handle=NULL);	// Cancel Alert Subscription from local AMT.

private:
	bool m_subscribed;	// True iff subscribed.

	static const int GENERATED_USERNAME_LEN;
	static const int GENERATED_PASSWORD_LEN;
	static const std::string DEFAULT_USER;
	static const std::string DEFAULT_PASS;

	bool GenRandAsciiBuf(unsigned char *pBuf, int len);
};

#endif
