/***************************************************************************
          publichubsproxy.h  -  Proxy model for public hubs filtering
                             -------------------
    begin                : Mon Sep 29 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PUBLICHUBSPROXY_H
#define PUBLICHUBSPROXY_H

/**
 * @author
 *
 * Needed to handle which columns to filter on and the user
 * count, QSortFilterProxyModel handles sorting.
 */

#include <QSortFilterProxyModel>

class DC_HubFilterObject;

class PublicHubsProxy : public QSortFilterProxyModel {
Q_OBJECT

public:
	/** Constructor */
	PublicHubsProxy( QObject * parent = 0 );
	/** Destructor */
	virtual ~PublicHubsProxy();

	/** Sets the filter, columns, user count etc. */
	void setFilter( DC_HubFilterObject * filter );

protected:
	/** Does the filtering */
	virtual bool filterAcceptsRow( int source_row, const QModelIndex & source_parent ) const;

private:
	/** Minimum user count */
	unsigned int minusers;
	/** Filter looks in name */
	bool inName;
	/** Filter looks in hub address */
	bool inAddress;
	/** Filter looks in description */
	bool inDesc;
};

#endif // PUBLICHUBSPROXY_H
