// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UQADD_D_TRACE_AARCH64_H_
#define VIXL_SIM_UQADD_D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_uqadd_D[] = {
  0x00000000000000fa, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x00000000000000bd, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000000fb, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x000000000000807a, 0x0000000000000000,
  0x000000000000807b, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000008000007a, 0x0000000000000000,
  0x000000008000007b, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x33333333333333b0, 0x0000000000000000,
  0x55555555555555d2, 0x0000000000000000,
  0x800000000000007a, 0x0000000000000000,
  0x800000000000007b, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0xaaaaaaaaaaaaab27, 0x0000000000000000,
  0xcccccccccccccd49, 0x0000000000000000,
  0xffffffff8000007d, 0x0000000000000000,
  0xffffffff8000007e, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffffffff807d, 0x0000000000000000,
  0xffffffffffff807e, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x000000007ffffffd, 0x0000000000000000,
  0x000000007ffffffe, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x3333333333333333, 0x0000000000000000,
  0x5555555555555555, 0x0000000000000000,
  0x7ffffffffffffffd, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0xaaaaaaaaaaaaaaaa, 0x0000000000000000,
  0xcccccccccccccccc, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000001, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000003, 0x0000000000000000,
  0x0000000000000041, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x0000000000008000, 0x0000000000000000,
  0x000000007ffffffe, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x0000000080000000, 0x0000000000000000,
  0x3333333333333334, 0x0000000000000000,
  0x5555555555555556, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000004, 0x0000000000000000,
  0xaaaaaaaaaaaaaaab, 0x0000000000000000,
  0xcccccccccccccccd, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000004, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8004, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffff84, 0x0000000000000000,
  0xffffffffffffffc1, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000002, 0x0000000000000000,
  0x0000000000000003, 0x0000000000000000,
  0x0000000000000004, 0x0000000000000000,
  0x0000000000000042, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000000081, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x0000000000008000, 0x0000000000000000,
  0x0000000000008001, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x0000000080000000, 0x0000000000000000,
  0x0000000080000001, 0x0000000000000000,
  0x3333333333333335, 0x0000000000000000,
  0x5555555555555557, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000004, 0x0000000000000000,
  0x8000000000000005, 0x0000000000000000,
  0xaaaaaaaaaaaaaaac, 0x0000000000000000,
  0xccccccccccccccce, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000004, 0x0000000000000000,
  0xffffffff80000005, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8004, 0x0000000000000000,
  0xffffffffffff8005, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffff84, 0x0000000000000000,
  0xffffffffffffff85, 0x0000000000000000,
  0xffffffffffffffc2, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000000040, 0x0000000000000000,
  0x0000000000000041, 0x0000000000000000,
  0x0000000000000042, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x00000000000000bd, 0x0000000000000000,
  0x00000000000000be, 0x0000000000000000,
  0x00000000000000bf, 0x0000000000000000,
  0x000000000000803d, 0x0000000000000000,
  0x000000000000803e, 0x0000000000000000,
  0x000000000000803f, 0x0000000000000000,
  0x000000008000003d, 0x0000000000000000,
  0x000000008000003e, 0x0000000000000000,
  0x000000008000003f, 0x0000000000000000,
  0x3333333333333373, 0x0000000000000000,
  0x5555555555555595, 0x0000000000000000,
  0x800000000000003d, 0x0000000000000000,
  0x800000000000003e, 0x0000000000000000,
  0x800000000000003f, 0x0000000000000000,
  0x8000000000000040, 0x0000000000000000,
  0x8000000000000041, 0x0000000000000000,
  0x8000000000000042, 0x0000000000000000,
  0x8000000000000043, 0x0000000000000000,
  0xaaaaaaaaaaaaaaea, 0x0000000000000000,
  0xcccccccccccccd0c, 0x0000000000000000,
  0xffffffff80000040, 0x0000000000000000,
  0xffffffff80000041, 0x0000000000000000,
  0xffffffff80000042, 0x0000000000000000,
  0xffffffff80000043, 0x0000000000000000,
  0xffffffffffff8040, 0x0000000000000000,
  0xffffffffffff8041, 0x0000000000000000,
  0xffffffffffff8042, 0x0000000000000000,
  0xffffffffffff8043, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffffc1, 0x0000000000000000,
  0xffffffffffffffc2, 0x0000000000000000,
  0xffffffffffffffc3, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x000000000000007d, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x00000000000000bd, 0x0000000000000000,
  0x00000000000000fa, 0x0000000000000000,
  0x00000000000000fb, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x000000000000807a, 0x0000000000000000,
  0x000000000000807b, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000008000007a, 0x0000000000000000,
  0x000000008000007b, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x33333333333333b0, 0x0000000000000000,
  0x55555555555555d2, 0x0000000000000000,
  0x800000000000007a, 0x0000000000000000,
  0x800000000000007b, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0xaaaaaaaaaaaaab27, 0x0000000000000000,
  0xcccccccccccccd49, 0x0000000000000000,
  0xffffffff8000007d, 0x0000000000000000,
  0xffffffff8000007e, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffffffff807d, 0x0000000000000000,
  0xffffffffffff807e, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x000000000000007e, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x00000000000000be, 0x0000000000000000,
  0x00000000000000fb, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x00000000000000fd, 0x0000000000000000,
  0x000000000000807b, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000000000807d, 0x0000000000000000,
  0x000000008000007b, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x000000008000007d, 0x0000000000000000,
  0x33333333333333b1, 0x0000000000000000,
  0x55555555555555d3, 0x0000000000000000,
  0x800000000000007b, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0x8000000000000081, 0x0000000000000000,
  0xaaaaaaaaaaaaab28, 0x0000000000000000,
  0xcccccccccccccd4a, 0x0000000000000000,
  0xffffffff8000007e, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffff80000081, 0x0000000000000000,
  0xffffffffffff807e, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xffffffffffff8081, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x000000000000007f, 0x0000000000000000,
  0x0000000000000080, 0x0000000000000000,
  0x0000000000000081, 0x0000000000000000,
  0x00000000000000bf, 0x0000000000000000,
  0x00000000000000fc, 0x0000000000000000,
  0x00000000000000fd, 0x0000000000000000,
  0x00000000000000fe, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000000000807d, 0x0000000000000000,
  0x000000000000807e, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x000000008000007d, 0x0000000000000000,
  0x000000008000007e, 0x0000000000000000,
  0x33333333333333b2, 0x0000000000000000,
  0x55555555555555d4, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0x8000000000000081, 0x0000000000000000,
  0x8000000000000082, 0x0000000000000000,
  0xaaaaaaaaaaaaab29, 0x0000000000000000,
  0xcccccccccccccd4b, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffff80000081, 0x0000000000000000,
  0xffffffff80000082, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffff8082, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000007ffd, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x000000000000803d, 0x0000000000000000,
  0x000000000000807a, 0x0000000000000000,
  0x000000000000807b, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000000000fffa, 0x0000000000000000,
  0x000000000000fffb, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x0000000080007ffa, 0x0000000000000000,
  0x0000000080007ffb, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x333333333333b330, 0x0000000000000000,
  0x555555555555d552, 0x0000000000000000,
  0x8000000000007ffa, 0x0000000000000000,
  0x8000000000007ffb, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0xaaaaaaaaaaab2aa7, 0x0000000000000000,
  0xcccccccccccd4cc9, 0x0000000000000000,
  0xffffffff80007ffd, 0x0000000000000000,
  0xffffffff80007ffe, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000007ffe, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x0000000000008000, 0x0000000000000000,
  0x000000000000803e, 0x0000000000000000,
  0x000000000000807b, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000000000807d, 0x0000000000000000,
  0x000000000000fffb, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x000000000000fffd, 0x0000000000000000,
  0x0000000080007ffb, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x0000000080007ffd, 0x0000000000000000,
  0x333333333333b331, 0x0000000000000000,
  0x555555555555d553, 0x0000000000000000,
  0x8000000000007ffb, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0x8000000000008001, 0x0000000000000000,
  0xaaaaaaaaaaab2aa8, 0x0000000000000000,
  0xcccccccccccd4cca, 0x0000000000000000,
  0xffffffff80007ffe, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xffffffff80008001, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x0000000000007fff, 0x0000000000000000,
  0x0000000000008000, 0x0000000000000000,
  0x0000000000008001, 0x0000000000000000,
  0x000000000000803f, 0x0000000000000000,
  0x000000000000807c, 0x0000000000000000,
  0x000000000000807d, 0x0000000000000000,
  0x000000000000807e, 0x0000000000000000,
  0x000000000000fffc, 0x0000000000000000,
  0x000000000000fffd, 0x0000000000000000,
  0x000000000000fffe, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x0000000080007ffd, 0x0000000000000000,
  0x0000000080007ffe, 0x0000000000000000,
  0x333333333333b332, 0x0000000000000000,
  0x555555555555d554, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0x8000000000008001, 0x0000000000000000,
  0x8000000000008002, 0x0000000000000000,
  0xaaaaaaaaaaab2aa9, 0x0000000000000000,
  0xcccccccccccd4ccb, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xffffffff80008001, 0x0000000000000000,
  0xffffffff80008002, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x000000007ffffffd, 0x0000000000000000,
  0x000000007ffffffe, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x000000008000003d, 0x0000000000000000,
  0x000000008000007a, 0x0000000000000000,
  0x000000008000007b, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x0000000080007ffa, 0x0000000000000000,
  0x0000000080007ffb, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x00000000fffffffa, 0x0000000000000000,
  0x00000000fffffffb, 0x0000000000000000,
  0x00000000fffffffc, 0x0000000000000000,
  0x33333333b3333330, 0x0000000000000000,
  0x55555555d5555552, 0x0000000000000000,
  0x800000007ffffffa, 0x0000000000000000,
  0x800000007ffffffb, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0xaaaaaaab2aaaaaa7, 0x0000000000000000,
  0xcccccccd4cccccc9, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x000000007ffffffe, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x0000000080000000, 0x0000000000000000,
  0x000000008000003e, 0x0000000000000000,
  0x000000008000007b, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x000000008000007d, 0x0000000000000000,
  0x0000000080007ffb, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x0000000080007ffd, 0x0000000000000000,
  0x00000000fffffffb, 0x0000000000000000,
  0x00000000fffffffc, 0x0000000000000000,
  0x00000000fffffffd, 0x0000000000000000,
  0x33333333b3333331, 0x0000000000000000,
  0x55555555d5555553, 0x0000000000000000,
  0x800000007ffffffb, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0x8000000080000001, 0x0000000000000000,
  0xaaaaaaab2aaaaaa8, 0x0000000000000000,
  0xcccccccd4cccccca, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x000000007fffffff, 0x0000000000000000,
  0x0000000080000000, 0x0000000000000000,
  0x0000000080000001, 0x0000000000000000,
  0x000000008000003f, 0x0000000000000000,
  0x000000008000007c, 0x0000000000000000,
  0x000000008000007d, 0x0000000000000000,
  0x000000008000007e, 0x0000000000000000,
  0x0000000080007ffc, 0x0000000000000000,
  0x0000000080007ffd, 0x0000000000000000,
  0x0000000080007ffe, 0x0000000000000000,
  0x00000000fffffffc, 0x0000000000000000,
  0x00000000fffffffd, 0x0000000000000000,
  0x00000000fffffffe, 0x0000000000000000,
  0x33333333b3333332, 0x0000000000000000,
  0x55555555d5555554, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0x8000000080000001, 0x0000000000000000,
  0x8000000080000002, 0x0000000000000000,
  0xaaaaaaab2aaaaaa9, 0x0000000000000000,
  0xcccccccd4ccccccb, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x3333333333333333, 0x0000000000000000,
  0x3333333333333334, 0x0000000000000000,
  0x3333333333333335, 0x0000000000000000,
  0x3333333333333373, 0x0000000000000000,
  0x33333333333333b0, 0x0000000000000000,
  0x33333333333333b1, 0x0000000000000000,
  0x33333333333333b2, 0x0000000000000000,
  0x333333333333b330, 0x0000000000000000,
  0x333333333333b331, 0x0000000000000000,
  0x333333333333b332, 0x0000000000000000,
  0x33333333b3333330, 0x0000000000000000,
  0x33333333b3333331, 0x0000000000000000,
  0x33333333b3333332, 0x0000000000000000,
  0x6666666666666666, 0x0000000000000000,
  0x8888888888888888, 0x0000000000000000,
  0xb333333333333330, 0x0000000000000000,
  0xb333333333333331, 0x0000000000000000,
  0xb333333333333332, 0x0000000000000000,
  0xb333333333333333, 0x0000000000000000,
  0xb333333333333334, 0x0000000000000000,
  0xb333333333333335, 0x0000000000000000,
  0xb333333333333336, 0x0000000000000000,
  0xdddddddddddddddd, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x5555555555555555, 0x0000000000000000,
  0x5555555555555556, 0x0000000000000000,
  0x5555555555555557, 0x0000000000000000,
  0x5555555555555595, 0x0000000000000000,
  0x55555555555555d2, 0x0000000000000000,
  0x55555555555555d3, 0x0000000000000000,
  0x55555555555555d4, 0x0000000000000000,
  0x555555555555d552, 0x0000000000000000,
  0x555555555555d553, 0x0000000000000000,
  0x555555555555d554, 0x0000000000000000,
  0x55555555d5555552, 0x0000000000000000,
  0x55555555d5555553, 0x0000000000000000,
  0x55555555d5555554, 0x0000000000000000,
  0x8888888888888888, 0x0000000000000000,
  0xaaaaaaaaaaaaaaaa, 0x0000000000000000,
  0xd555555555555552, 0x0000000000000000,
  0xd555555555555553, 0x0000000000000000,
  0xd555555555555554, 0x0000000000000000,
  0xd555555555555555, 0x0000000000000000,
  0xd555555555555556, 0x0000000000000000,
  0xd555555555555557, 0x0000000000000000,
  0xd555555555555558, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x7ffffffffffffffd, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x800000000000003d, 0x0000000000000000,
  0x800000000000007a, 0x0000000000000000,
  0x800000000000007b, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x8000000000007ffa, 0x0000000000000000,
  0x8000000000007ffb, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x800000007ffffffa, 0x0000000000000000,
  0x800000007ffffffb, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0xb333333333333330, 0x0000000000000000,
  0xd555555555555552, 0x0000000000000000,
  0xfffffffffffffffa, 0x0000000000000000,
  0xfffffffffffffffb, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x7ffffffffffffffe, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x800000000000003e, 0x0000000000000000,
  0x800000000000007b, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x8000000000007ffb, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x800000007ffffffb, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0xb333333333333331, 0x0000000000000000,
  0xd555555555555553, 0x0000000000000000,
  0xfffffffffffffffb, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x7fffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x800000000000003f, 0x0000000000000000,
  0x800000000000007c, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x8000000000007ffc, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x800000007ffffffc, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0xb333333333333332, 0x0000000000000000,
  0xd555555555555554, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x8000000000000000, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000040, 0x0000000000000000,
  0x800000000000007d, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000007ffd, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x800000007ffffffd, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0xb333333333333333, 0x0000000000000000,
  0xd555555555555555, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x8000000000000001, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000041, 0x0000000000000000,
  0x800000000000007e, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0x8000000000007ffe, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0x800000007ffffffe, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0xb333333333333334, 0x0000000000000000,
  0xd555555555555556, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x8000000000000002, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000004, 0x0000000000000000,
  0x8000000000000042, 0x0000000000000000,
  0x800000000000007f, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0x8000000000000081, 0x0000000000000000,
  0x8000000000007fff, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0x8000000000008001, 0x0000000000000000,
  0x800000007fffffff, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0x8000000080000001, 0x0000000000000000,
  0xb333333333333335, 0x0000000000000000,
  0xd555555555555557, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0x8000000000000003, 0x0000000000000000,
  0x8000000000000004, 0x0000000000000000,
  0x8000000000000005, 0x0000000000000000,
  0x8000000000000043, 0x0000000000000000,
  0x8000000000000080, 0x0000000000000000,
  0x8000000000000081, 0x0000000000000000,
  0x8000000000000082, 0x0000000000000000,
  0x8000000000008000, 0x0000000000000000,
  0x8000000000008001, 0x0000000000000000,
  0x8000000000008002, 0x0000000000000000,
  0x8000000080000000, 0x0000000000000000,
  0x8000000080000001, 0x0000000000000000,
  0x8000000080000002, 0x0000000000000000,
  0xb333333333333336, 0x0000000000000000,
  0xd555555555555558, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xaaaaaaaaaaaaaaaa, 0x0000000000000000,
  0xaaaaaaaaaaaaaaab, 0x0000000000000000,
  0xaaaaaaaaaaaaaaac, 0x0000000000000000,
  0xaaaaaaaaaaaaaaea, 0x0000000000000000,
  0xaaaaaaaaaaaaab27, 0x0000000000000000,
  0xaaaaaaaaaaaaab28, 0x0000000000000000,
  0xaaaaaaaaaaaaab29, 0x0000000000000000,
  0xaaaaaaaaaaab2aa7, 0x0000000000000000,
  0xaaaaaaaaaaab2aa8, 0x0000000000000000,
  0xaaaaaaaaaaab2aa9, 0x0000000000000000,
  0xaaaaaaab2aaaaaa7, 0x0000000000000000,
  0xaaaaaaab2aaaaaa8, 0x0000000000000000,
  0xaaaaaaab2aaaaaa9, 0x0000000000000000,
  0xdddddddddddddddd, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xcccccccccccccccc, 0x0000000000000000,
  0xcccccccccccccccd, 0x0000000000000000,
  0xccccccccccccccce, 0x0000000000000000,
  0xcccccccccccccd0c, 0x0000000000000000,
  0xcccccccccccccd49, 0x0000000000000000,
  0xcccccccccccccd4a, 0x0000000000000000,
  0xcccccccccccccd4b, 0x0000000000000000,
  0xcccccccccccd4cc9, 0x0000000000000000,
  0xcccccccccccd4cca, 0x0000000000000000,
  0xcccccccccccd4ccb, 0x0000000000000000,
  0xcccccccd4cccccc9, 0x0000000000000000,
  0xcccccccd4cccccca, 0x0000000000000000,
  0xcccccccd4ccccccb, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000040, 0x0000000000000000,
  0xffffffff8000007d, 0x0000000000000000,
  0xffffffff8000007e, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80007ffd, 0x0000000000000000,
  0xffffffff80007ffe, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffff80000001, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000041, 0x0000000000000000,
  0xffffffff8000007e, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffff80007ffe, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffff80000002, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000004, 0x0000000000000000,
  0xffffffff80000042, 0x0000000000000000,
  0xffffffff8000007f, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffff80000081, 0x0000000000000000,
  0xffffffff80007fff, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xffffffff80008001, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffff80000003, 0x0000000000000000,
  0xffffffff80000004, 0x0000000000000000,
  0xffffffff80000005, 0x0000000000000000,
  0xffffffff80000043, 0x0000000000000000,
  0xffffffff80000080, 0x0000000000000000,
  0xffffffff80000081, 0x0000000000000000,
  0xffffffff80000082, 0x0000000000000000,
  0xffffffff80008000, 0x0000000000000000,
  0xffffffff80008001, 0x0000000000000000,
  0xffffffff80008002, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8040, 0x0000000000000000,
  0xffffffffffff807d, 0x0000000000000000,
  0xffffffffffff807e, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffff8001, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8041, 0x0000000000000000,
  0xffffffffffff807e, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffff8002, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8004, 0x0000000000000000,
  0xffffffffffff8042, 0x0000000000000000,
  0xffffffffffff807f, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffff8003, 0x0000000000000000,
  0xffffffffffff8004, 0x0000000000000000,
  0xffffffffffff8005, 0x0000000000000000,
  0xffffffffffff8043, 0x0000000000000000,
  0xffffffffffff8080, 0x0000000000000000,
  0xffffffffffff8081, 0x0000000000000000,
  0xffffffffffff8082, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffff81, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffffc1, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffff82, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffff84, 0x0000000000000000,
  0xffffffffffffffc2, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffff83, 0x0000000000000000,
  0xffffffffffffff84, 0x0000000000000000,
  0xffffffffffffff85, 0x0000000000000000,
  0xffffffffffffffc3, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffffc1, 0x0000000000000000,
  0xffffffffffffffc2, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xfffffffffffffffd, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
  0xffffffffffffffff, 0x0000000000000000,
};
const unsigned kExpectedCount_NEON_uqadd_D = 1600;

#endif  // VIXL_SIM_UQADD_D_TRACE_AARCH64_H_
