/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.InvalidFieldConnectionException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.InvalidNodeTypeException;
import org.web3d.vrml.lang.NodeTemplateToInstanceCreator;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.ImportNodeProxy;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.ProtoBodyGroupNode;
import org.web3d.vrml.nodes.proto.ProtoFieldInfo;
import org.web3d.vrml.nodes.proto.ProtoROUTE;

public class PrototypeDecl
extends AbstractProto
implements VRMLProtoDeclare {
    private static final String NO_FIELD_MSG = "No field at index ";
    private static final String EVENTIN_MSG = "No value, field is an eventIn ";
    private static final String INVALID_ROOT_MSG = "The instance creation function has an invalid root node type ";
    private ProtoBodyGroupNode bodyGroup = new ProtoBodyGroupNode();
    private HashMap isMap = new HashMap();
    private HashSet routes;
    private HashMap imports;
    private HashMap defs;
    private IntHashMap fieldValueMap = new IntHashMap();

    public PrototypeDecl(String string, int n, int n2, NodeTemplateToInstanceCreator nodeTemplateToInstanceCreator) {
        super(string, n, n2, nodeTemplateToInstanceCreator);
        this.routes = new HashSet();
        this.imports = new HashMap();
        this.defs = new HashMap();
    }

    public VRMLNode createNewInstance(VRMLNode vRMLNode, boolean bl) throws InvalidNodeTypeException {
        VRMLNode vRMLNode2 = null;
        if (vRMLNode instanceof VRMLWorldRootNodeType) {
            vRMLNode2 = this.protoCreator.newInstance(this, (VRMLWorldRootNodeType)vRMLNode, this.vrmlMajorVersion, this.vrmlMinorVersion, bl);
        } else if (vRMLNode instanceof VRMLProtoInstance) {
            vRMLNode2 = this.protoCreator.newInstance(this, (VRMLProtoInstance)vRMLNode, this.vrmlMajorVersion, this.vrmlMinorVersion, bl);
        } else {
            throw new InvalidNodeTypeException(INVALID_ROOT_MSG + vRMLNode);
        }
        return vRMLNode2;
    }

    public void addFieldNodeValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        LinkedList<VRMLNodeType> linkedList = (LinkedList<VRMLNodeType>)this.fieldValueMap.get(n);
        if (linkedList == null) {
            linkedList = new LinkedList<VRMLNodeType>();
            this.fieldValueMap.put(n, linkedList);
        }
        linkedList.add(vRMLNodeType);
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData;
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        if (vRMLFieldDeclaration.getAccessType() == 1) {
            throw new InvalidFieldException(EVENTIN_MSG + vRMLFieldDeclaration.getName());
        }
        Object object = this.fieldValueMap.get(n);
        if (object instanceof List) {
            vRMLFieldData = new VRMLFieldData();
            this.fieldValueMap.put(n, vRMLFieldData);
            List list = (List)object;
            if (vRMLFieldDeclaration.getFieldType() == 11) {
                vRMLFieldData.dataType = (short)7;
                vRMLFieldData.nodeValue = (VRMLNode)list.get(0);
            } else {
                vRMLFieldData.dataType = (short)13;
                vRMLFieldData.numElements = list.size();
                vRMLFieldData.nodeArrayValue = new VRMLNodeType[list.size()];
                list.toArray(vRMLFieldData.nodeArrayValue);
            }
        } else {
            vRMLFieldData = (VRMLFieldData)object;
        }
        return vRMLFieldData;
    }

    public int getPrimaryType() {
        return this.bodyGroup.getPrimaryType();
    }

    public void addRouteDecl(ProtoROUTE protoROUTE) {
        this.routes.add(protoROUTE);
    }

    public Set getRouteDecls() {
        return Collections.unmodifiableSet(this.routes);
    }

    public void addImportDecl(String string, ImportNodeProxy importNodeProxy) {
        this.imports.put(string, importNodeProxy);
    }

    public Map getImportDecls() {
        return this.imports;
    }

    public void setDEFMap(Map map) {
        this.defs.putAll(map);
    }

    public Map getDEFMap() {
        return this.defs;
    }

    public VRMLGroupingNodeType getBodyGroup() {
        return this.bodyGroup;
    }

    public void addIS(String string, VRMLNodeType vRMLNodeType, int n) throws InvalidFieldException, InvalidFieldConnectionException {
        ArrayList<ProtoFieldInfo> arrayList;
        Integer n2 = (Integer)this.fieldIndexMap.get(string);
        if (n2 == null) {
            throw new InvalidFieldException("Source for IS not known to " + this.nodeName, string);
        }
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n2);
        VRMLFieldDeclaration vRMLFieldDeclaration2 = vRMLNodeType.getFieldDeclaration(n);
        if (vRMLFieldDeclaration2 == null) {
            throw new InvalidFieldException("Destination for IS not known.  destNode: " + vRMLNodeType.getVRMLNodeName() + " fromField: " + string + " toIdx: " + n);
        }
        if (vRMLFieldDeclaration.getFieldType() != vRMLFieldDeclaration2.getFieldType()) {
            throw new InvalidFieldConnectionException("No match on IS data types. Source (" + vRMLFieldDeclaration.getName() + ") is " + vRMLFieldDeclaration.getFieldTypeString() + " and destination (" + vRMLFieldDeclaration2.getName() + ") is " + vRMLFieldDeclaration2.getFieldTypeString());
        }
        int n3 = vRMLFieldDeclaration2.getAccessType();
        boolean bl = false;
        switch (vRMLFieldDeclaration.getAccessType()) {
            case 3: {
                bl = n3 == 3;
                break;
            }
            case 2: {
                bl = n3 == 2 || n3 == 3;
                break;
            }
            case 1: {
                bl = n3 == 3 || n3 == 1;
                break;
            }
            case 4: {
                boolean bl2 = bl = n3 == 3 || n3 == 4;
            }
        }
        if (!bl) {
            throw new InvalidFieldConnectionException("IS access types are not compatible. Source (" + vRMLFieldDeclaration.getName() + ") is " + VRMLFieldDeclaration.toAccessTypeString(vRMLFieldDeclaration.getAccessType(), this.isVrml97) + " and destination (" + vRMLFieldDeclaration2.getName() + ") is " + VRMLFieldDeclaration.toAccessTypeString(n3, this.isVrml97));
        }
        if (this.isVRML97()) {
            this.checkAccessMatch(vRMLFieldDeclaration, vRMLFieldDeclaration2);
        }
        if ((arrayList = (ArrayList<ProtoFieldInfo>)this.isMap.get(n2)) == null) {
            arrayList = new ArrayList<ProtoFieldInfo>(5);
            this.isMap.put(n2, arrayList);
        }
        arrayList.add(new ProtoFieldInfo(vRMLNodeType, n));
    }

    public Map getISMaps() {
        return Collections.unmodifiableMap(this.isMap);
    }

    private void checkAccessMatch(VRMLFieldDeclaration vRMLFieldDeclaration, VRMLFieldDeclaration vRMLFieldDeclaration2) throws InvalidFieldConnectionException {
        int n = vRMLFieldDeclaration2.getAccessType();
        switch (vRMLFieldDeclaration.getAccessType()) {
            case 3: {
                if (n == 3) break;
                throw new InvalidFieldConnectionException("Invalid IS access. Proto decl field is an exposedField and destination is not an exposedField");
            }
            case 2: {
                if (n != 1 && n != 4) break;
                throw new InvalidFieldConnectionException("Invalid IS access. Proto decl field is a field  and destination is not field or exposedField");
            }
            case 1: {
                if (n != 2 && n != 4) break;
                throw new InvalidFieldConnectionException("Invalid IS access. Proto decl field is an eventIn  and destination is a field or eventOut");
            }
            case 4: {
                if (n != 2 && n != 1) break;
                throw new InvalidFieldConnectionException("Invalid IS access. Proto decl field is an eventOut  and destination is a field or eventIn");
            }
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)2;
        vRMLFieldData.intValue = n2;
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)9;
        vRMLFieldData.intArrayValue = nArray;
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 4: {
                vRMLFieldData.numElements = n2;
                break;
            }
            case 25: {
                vRMLFieldData.numElements = 1;
                break;
            }
            case 26: {
                int n3;
                for (int i = 0; i < nArray.length; i += n3) {
                    ++vRMLFieldData.numElements;
                    n3 = nArray[i] * nArray[i + 1] + 1;
                }
                break;
            }
            default: {
                System.out.println("PrototypeDecl setValue(int[]) unknown field type: " + vRMLFieldDeclaration.getFieldType());
            }
        }
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = 1;
        vRMLFieldData.booleanValue = bl;
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, boolean[] blArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)8;
        vRMLFieldData.booleanArrayValue = blArray;
        vRMLFieldData.numElements = n2;
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)4;
        vRMLFieldData.floatValue = f;
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)11;
        vRMLFieldData.floatArrayValue = fArray;
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 6: {
                vRMLFieldData.numElements = n2;
                break;
            }
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 23: {
                vRMLFieldData.numElements = 1;
                break;
            }
            case 14: {
                vRMLFieldData.numElements = n2 / 2;
                break;
            }
            case 16: 
            case 22: {
                vRMLFieldData.numElements = n2 / 3;
                break;
            }
            case 20: 
            case 24: {
                vRMLFieldData.numElements = n2 / 4;
                break;
            }
            default: {
                System.out.println("PrototypeDecl setValue(float[]) unknown field type: " + vRMLFieldDeclaration.getFieldTypeString());
            }
        }
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, long l) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)3;
        vRMLFieldData.longValue = l;
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, long[] lArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)10;
        vRMLFieldData.longArrayValue = lArray;
        vRMLFieldData.numElements = n2;
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)5;
        vRMLFieldData.doubleValue = d;
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)12;
        vRMLFieldData.doubleArrayValue = dArray;
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 10: {
                vRMLFieldData.numElements = n2;
                break;
            }
            case 17: 
            case 29: {
                vRMLFieldData.numElements = 1;
                break;
            }
            case 30: {
                vRMLFieldData.numElements = n2 / 2;
                break;
            }
            case 18: {
                vRMLFieldData.numElements = n2 / 3;
                break;
            }
            default: {
                System.out.println("PrototypeDecl setValue(float[]) unknown field type: " + vRMLFieldDeclaration.getFieldTypeString());
            }
        }
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)6;
        vRMLFieldData.stringValue = string;
        this.fieldValueMap.put(n, vRMLFieldData);
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(NO_FIELD_MSG + n);
        }
        VRMLFieldData vRMLFieldData = new VRMLFieldData();
        vRMLFieldData.dataType = (short)14;
        vRMLFieldData.stringArrayValue = stringArray;
        vRMLFieldData.numElements = n2;
        this.fieldValueMap.put(n, vRMLFieldData);
    }
}

