/*
 *========================================================================
 * $Id: sysvipc.c 88 2004-09-28 22:49:38Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf.h>

/*
 * <sysvipc> tag init and update (same thing)
 */
void init_sysvipc(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_INIT_VALUES)){
   fprintf(OUTFP,"D_INIT_VALUES: Starting init_sysvipc().  Use -v %d to focus.\n",D_INIT_VALUES);
   
 }

 /* 
  * sysvipc - tv_sec and tv_usec timestamps.
  */
 /* <sysvipc tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[SYSVIPC],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[SYSVIPC]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.sysvipc_tv_sec = seconds;

 /* <sysvipc tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[SYSVIPC],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[SYSVIPC]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.sysvipc_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: sysvipc_tv_sec = %ul sysvipc_tv_usec = %ul\n",hostptr->val.sysvipc_tv_sec,hostptr->val.sysvipc_tv_usec);
 }

}


void update_sysvipc(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_INIT_VALUES)){
   fprintf(OUTFP,"D_INIT_VALUES: Starting init_sysvipc().  Use -v %d to focus.\n",D_INIT_VALUES);
   
 }

 /* 
  * sysvipc - tv_sec and tv_usec timestamps.
  */
 /* <sysvipc tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[SYSVIPC],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[SYSVIPC]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.sysvipc_tv_sec = seconds;

 /* <sysvipc tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[SYSVIPC],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[SYSVIPC]);
 }
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.sysvipc_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_UPDATE_VALUES)){
   fprintf(OUTFP,"D_UPDATE_VALUES: sysvipc_tv_sec = %ul sysvipc_tv_usec = %ul\n",hostptr->val.sysvipc_tv_sec,hostptr->val.sysvipc_tv_usec);
 }

}
