//////////////////////////////////////////////////////////////////////////////
// Name:        SVGAngle.h
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by generate.py
//////////////////////////////////////////////////////////////////////////////

#ifndef WX_SVG_ANGLE_H
#define WX_SVG_ANGLE_H

#include "String_wxsvg.h"


enum wxSVG_ANGLETYPE
{
  wxSVG_ANGLETYPE_UNKNOWN = 0,
  wxSVG_ANGLETYPE_UNSPECIFIED = 1,
  wxSVG_ANGLETYPE_DEG = 2,
  wxSVG_ANGLETYPE_RAD = 3,
  wxSVG_ANGLETYPE_GRAD = 4
};

class wxSVGAngle
{
  protected:
    wxSVG_ANGLETYPE m_unitType;
    double m_value;
    double m_valueInSpecifiedUnits;

  public:
    inline wxSVG_ANGLETYPE GetUnitType() const { return m_unitType; }
    inline void SetUnitType(const wxSVG_ANGLETYPE& n) { m_unitType = n; }

  public:
    wxSVGAngle() : m_unitType(wxSVG_ANGLETYPE_UNKNOWN), m_value(0) {}
    wxSVGAngle(double v) : m_unitType(wxSVG_ANGLETYPE_UNSPECIFIED), m_value(v) {}
    virtual ~wxSVGAngle() {}
    
    inline double GetValue() const { return m_value; }
    inline void SetValue(double n) { m_unitType = wxSVG_ANGLETYPE_UNSPECIFIED; m_valueInSpecifiedUnits = n; m_value = n; }
    inline operator double() const { return GetValue(); }
    
    inline double GetValueInSpecifiedUnits() const { return m_valueInSpecifiedUnits; }
    void SetValueInSpecifiedUnits(double n);
    
    wxString GetValueAsString() const;
    void SetValueAsString(const wxString& n);
    
    virtual void NewValueSpecifiedUnits(wxSVG_ANGLETYPE unitType, double valueInSpecifiedUnits);
    virtual void ConvertToSpecifiedUnits(wxSVG_ANGLETYPE unitType);
};

#endif // WX_SVG_ANGLE_H
